string GetDescription()
{
	return "This is a very simple dance style arrangement.";
}

int GetRandom(int[] @patches)
{
	return patches[RndInt(0, patches.length()-1)];
}

void Arrange(Song @s)
{
	int bars = s.GetBars();	

	s.AddTrack("Melody", 2,127,64);
	s.AddTrack("Alt Voice", 2,127,64);
	s.AddTrack("Pad", RndInt(89,96),127,64);
	
	if (RndInt(0,1) == 0) s.AddTrack("Bass", 36,127,64);
	else s.AddTrack("Bass", RndInt(39,40),127,64);
	
	int[] acomp_pitch = { 5,6,27,39,46,63,97,103,107 };
	
	s.AddTrack("Accomp", GetRandom(acomp_pitch),127,64); 
	s.AddTrack("Drums", 1,127,64);
	
	s.AddTrack("Strings", RndInt(51,52),127,64);
	s.AddTrack("Lead Bass", 88,127,64);
	
	s.AddTrack("Voice Powerup", 92,127,64);
	
	s.AddTrack("Acomp 2", 1,127,64);

	double back = 0.5;
	if (s.GetTempo() > 90) back = 1.0;
	
	int cnt = 0;
	int chorus_cnt = 0;
	
	int attack_seed = RndInt(0,32000);
	int start_cyk_with = RndInt(0,3);
	int start_bit_with = RndInt(start_cyk_with,start_cyk_with+2);
	int start_acomp_with = RndInt(0,3);
	
	int drum_seed1 = RndInt(0,32000);
	int drum_seed2 = RndInt(0,32000);
	
	int arp_seed = RndInt(0,32000);
	
	for (int i = 0; i < s.GetParts(); i++)
	{
		if (s.GetPart(i).GetArrHint() == 0)
		{
			
		}
		else
		{
			if (s.GetPart(i).GetArrHint() == 1 || s.GetPart(i).GetArrHint() == 3)
			{
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,0), 1.0); 
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,back), 0.7); 
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,2*back), 0.5); 
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,3*back), 0.3); 
			}
			
			if (s.GetPart(i).GetArrHint() == 2 || s.GetPart(i).GetArrHint() == 3)
			{
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,0), 1.0); 
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,back), 0.7); 
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,2*back), 0.5); 
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,3*back), 0.3); 
			}
		}
		
		if (s.GetPart(i).GetArrHint() == 3)
		{
			if (RndInt(0,7) != 0)
			{
				s.AddRenderEvent("Drums - Dance Hi-Hat", drum_seed1, 5, s.GetPartStartBar(i) , s.GetPartEndBar(i), 1, CreateTime(0,0), 1.0); 
				s.AddRenderEvent("Drums - Dance Foot & Snare", drum_seed2, 5, s.GetPartStartBar(i) , s.GetPartEndBar(i), 1, CreateTime(0,0), 1.0); 
			}
	
			if (RndInt(0,4) != 1)
			{
				s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), 2, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.85); 
				s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), 6, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),0.70); 
			}
			
			s.AddRenderEvent("Random Bass", 6, 3, s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0),1.0); 			
			s.AddRenderEvent("Random Bass", 1, 7, s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0.5),1.0); 			
			s.AddRenderEvent("Random Bass", 1, 7, s.GetPartStartBar(i), s.GetPartEndBar(i), 0, CreateTime(0,0.0),1.0); 			
			
			s.AddRenderEvent("Drums - Dance Snare Attack", attack_seed, 5, ((s.GetPartStartBar(i)+s.GetPartEndBar(i))/2)-2 , (s.GetPartStartBar(i)+s.GetPartEndBar(i))/2, 1, CreateTime(0,0), 1.0); 
			s.AddRenderEvent("Drums - Dance Snare Attack", attack_seed, 5, s.GetPartEndBar(i)-2 , s.GetPartEndBar(i), 1, CreateTime(0,0), 1.0); 
			
			if (chorus_cnt > 1) s.AddRenderEvent("Arpeggio Chords Fast",arp_seed, 4, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0.0),0.9); 
			
			if (chorus_cnt > 2) s.AddRenderEvent("Simple Melody", RndInt(0,32000), 8, s.GetPartStartBar(i) , s.GetPartEndBar(i), RndInt(2,3), CreateTime(0,0), 1.0); 			
		
			chorus_cnt++;	
		}
		else
		{
			if (i+1 < s.GetParts() && s.GetPart(i+1).GetArrHint() == 3)
			{
				if (RndInt(0,1) == 0 && i != 0) s.AddRenderEvent("Drums - Dance Snare Attack", attack_seed, 5, s.GetPartStartBar(i) , s.GetPartEndBar(i), 1, CreateTime(0,0), 1.0); 
				else s.AddRenderEvent("Drums - Dance Snare Attack", attack_seed, 5, (s.GetPartStartBar(i)+s.GetPartEndBar(i))/2 , s.GetPartEndBar(i), 1, CreateTime(0,0), 1.0); 
			}
			
			if (cnt == 0)
			{
				s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), 2, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.65); 
				s.AddRenderEvent("Simple Bass", RndInt(0,32000), 3, s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0),1.0); 			
			}
			else if (cnt >= 1)
			{
				s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), 2, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.75); 
				s.AddRenderEvent("Random Bass", 2, 3, s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0),1.0); 			
				s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), 6, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),0.65); 
			}
			
			if (cnt >= start_cyk_with)
				s.AddRenderEvent("Drums - Dance Hi-Hat", drum_seed1, 5, s.GetPartStartBar(i) , s.GetPartEndBar(i), 1, CreateTime(0,0), 0.9); 	
			
			if (cnt >= start_bit_with)
				s.AddRenderEvent("Drums - Dance Foot & Snare", drum_seed2, 5, s.GetPartStartBar(i) , s.GetPartEndBar(i), 1, CreateTime(0,0), 0.9); 	
			
			if (cnt >= start_acomp_with)
				s.AddRenderEvent("Arpeggio Chords Fast", RndInt(0,32000), 4, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0.0),0.9); 			
			
				
			s.AddRenderEvent("Sine Velocity Simple Melody", RndInt(0,32000), 9, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0.0),0.9); 			
			
			cnt++;
		}
	}
}